<?php

include 'db.php';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Swipe Page Transition</title>
    <!-- <link rel="stylesheet" href="assests/css/bootstrap.min.css"> -->
    <link rel="stylesheet" href="assests/css/style.css">

    <!-- <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"> -->

      <!-- Bootstrap link -->
      <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
      <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
      <link rel="stylesheet" href="assests/css/icon-font.min.css">
  
      <!-- Vertical carousel slick theme -->
      <link rel="stylesheet" href="https://kenwheeler.github.io/slick/slick/slick.css">
      <link rel="stylesheet" href="https://kenwheeler.github.io/slick/slick/slick-theme.css">

      <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">

      <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

    <style>
        /* (Use the same CSS styles as provided in the React version) */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            user-select: none;
        }

        body {
            /* background-color: #b5abb6; */
            /* background-color: #f8d45d1f; */
            background-color: transparent;
            /* overscroll-behavior-y: contain; */
        }

        #container {
            /* width: 400px; */
            /* height: 100vh; */
            /* position: absolute; */
            /* box-shadow: 0px 0px 25px -8px rgba(53, 53, 53, 0.82); */
            overflow-y: scroll;
            overflow-x: hidden;
        }
        
        #page0 {
            background: transparent;
        }

        #page1 {
            background-image: linear-gradient(to right, #670185 0%, #430053 100%);
        }

        #page2 {
            background-image: linear-gradient(to right, #ff2c2c 0%, #b50031 100%);
        }

        #root {
            display: flex;
            justify-content: center;
        }

        svg {
            position: fixed;
            height: 100%;
            z-index: 1001;
        }

        button {
            /* position: absolute; */
            /* top: -627px; */
            /* left: 70px; */
            width: 40px;
            height: 40px;
            font-size: 25px;
            font-weight: 700;
            border-radius: 50%;
            font-family: "Oswald", sans-serif;
            background: transparent;
            color: #FCD863;
            /* border: 1px solid rgba(255, 255, 255, 0.4); */
            border: none;
            /* top: 10px; */
            /* left: 80px; */
        }


        button:focus {
            outline: 0;
        }

        img {
            width: 43vh;
            /* margin-left: 15px; */
        }

        .header {
            display: flex;
            justify-content: space-between;
            color: rgb(255, 255, 255);
            font-family: "Roboto", sans-serif;
            font-size: 19px;
            padding: 0px 31px;
        }

        #header0 {
            color: #000;
        }

        #header1 {
            color: rgb(255, 255, 255);
        }

        #header2 {
            color: #fff;
        }

        .skip {
            font-weight: 400;
        }

        #content {
            display: flex;
            flex-direction: column;
            padding: 0px 48px;
            height: 30vh;
            /* position: relative; */
        }

        .contentL1 {
            color: rgb(0, 0, 0);
            font-family: monospace;
            font-weight: 100;
            text-align: left;
            letter-spacing: -2px;
            line-height: 18px;
            opacity: 0.3;
        }

        .contentL2 {
            color: #000;
            font-family: "Oswald", sans-serif;
            margin-bottom: 8px;
            text-align: left;
        }

        .contentL3 {
            color: #000;
            font-family: "Roboto", sans-serif;
            text-align: left;
            font-size: 15px;
            font-weight: 100;
            word-spacing: 2px;
            letter-spacing: 1px;
            opacity: 0.5;
        }

        .text0 {
            color: #000;
        }

        .text1 {
            color: #fd5888;
        }

        .text2 {
            color: #fff;
        }

        .button0 {
            text-transform: uppercase;
            font-size: 25px;
            font-weight: 700;
            color: #FCD863;
            /* top: -627px; */
            /* left: 70px; */
            /* border: 1px solid rgba(0, 0, 0, 0.0); */
            background-color: transparent;
            border: none;
            z-index: 1001;
            position: fixed;
            transition: transform 0.3s ease-in;
            transform-origin: center;
        }

        .button.dragging {
            animation: dragAnimation 2s ease-in-out infinite;
        }

        @keyframes dragAnimation {
            0% {
                transform: translateX(0) translateY(0);
            }
            50% {
                transform: translateX(50%) translateY(0);
            }
            100% {
                transform: translateX(100%) translateY(0);
            }
        }

        .button1 {
            color: #fff;
            border: 1px solid rgba(255, 255, 255, 0.4);
           
        }

        .button2 {
            color: #fff;
            border: 1px solid rgba(255, 255, 255, 0.4);
        }

        @media only screen and (max-width: 500px) {
            #container {
                /* width: 100%; */
            }
        }

        .card-title {
            margin-bottom: 0;
        }

        p {
            margin-top: 0;
            margin-bottom: 0;
        }

        .row {
            margin-right: 0px;
            margin-left: 0px;
        }

        .card {
            border-radius: 15px;
        }

        .scrollbar-container {
            /* max-width: 100vh; */
            overflow-x: hidden !important;
            overflow-y: scroll;
            position: relative;
            overflow-x: hidden;
        }

        ::-webkit-scrollbar {
            width: 4px !important;
            /* background: beige; */
            /* background-color: transparent; */
            overflow-x: hidden !important;
        }

        ::-webkit-scrollbar-thumb {
            background: #000;
            overflow-x: hidden !important;
        }

        ::-webkit-scrollbar-track {
            /* width: 10px; */
            /* background-color: beige; */
        }
        
        /* Scrollbar */
        .scrollbar-container {
            --scrollbar-color-track: transparent;
            --scrollbar-color-thumb: #0B132B;
            overflow-x: hidden !important;
        }

       
        @supports (scrollbar-width: auto) {
            .scrollbar-container {
                scrollbar-color: var(--scrollbar-color-thumb) var(--scrollbar-color-track);
                overflow-x: hidden !important;
            }

            .warning {
                display: none;
            }
        }

        .scrollbar-container {
            /* height: 100vh; */
            position: relative;
            container-type: inline-size;
        }

        .increase-num {
            z-index: 10;
        }
        .num-anim {
            color: lightgray;
            /* animation: zoom-in-zoom-out 1s ease-out; */
            display: none;
            z-index: 10; 
        }

        .num-anim.animate {
            animation: zoom-in-zoom-out 0.5s ease-out;
            z-index: 1;
        }

        .swipe-indicator {
            position: fixed;
            top: 50%;
            left: -40px;
            transform: translateY(-50%);
            /* background-color: #000; */
            color: #000;
            padding-left: 25px;
            cursor: pointer;
            z-index: 1001;
            display: flex;
            align-items: center;
            /* animation: swipeAnimation 2s ease-in-out infinite;  */
            transition: transform 0.3s ease-in; 
            border-top: 0px;
            border-bottom: 0px;
            border-left: 0px;
            border-right: 1px;
            border-style: solid;
            border-color: lightgray;
            padding-top: 50px;
            padding-bottom: 50px;
            box-shadow: 1px 5px 5px 1px #cfd1d5c7;
            /* border-radius: 0 50px 50px 0; */
            border-radius: 0 50% 50% 0;
            width: 10px;
        }

        #site-wrapper {
            position: fixed;
            top: 40%;
            left: -80px;
            transform: translate(-50%);
            cursor: pointer;
            transition: transform 0.3s ease-in; 
            /* width: 10%; */
            /* max-width: 100px; */
        }


        .arrow-icon {
            margin-left: auto; 
            transition: transform 0.3s ease;
        }

        @keyframes swipeAnimation {
            0%, 100% {
                transform: translateY(-50%) translateX(0);
            }
            50% {
                transform: translateY(-50%) translateX(10px);
            }
        }

        #hamburger-container-curve {
            fill: transparent;
            stroke: lightgray;
            filter: drop-shadow(0 4px 4px rgba(0, 0, 0, 0.25));
        }
        /* @keyframes swipeAnimation {
            0% {
                transform: translateY(-50%) translateX(0);
            }
            50% {
                transform: translateY(-50%) translateX(5px);
            }
            100% {
                transform: translateY(-50%) translateX(0);
            }
        } */

        .no-scroll {
                overflow: hidden;
        width: 0px; 
            }
        @media (max-width: 480px) {

            #container {
                overflow: hidden;
            }
            .content {
                overflow-y: auto; 
                max-height: 86vh;
                top: 20px;
            }
            .content::-webkit-scrollbar {

            }

            /* Track */
            body::-webkit-scrollbar-track,
            body::-webkit-scrollbar-track {
                /* background: white;  */
            }

            /* Handle */
            body::-webkit-scrollbar-thumb,  
            body::-webkit-scrollbar-thumb {
                /* background: #0B132B;  */
            }

            /* Handle on hover */
            body::-webkit-scrollbar-thumb:hover,
            body::-webkit-scrollbar-thumb:hover {
                /* background: #000000;  */
            }
        }
         
        #container {
            display: none;
        }
       
        @media (max-width: 480px) {
            #container {
            display: block;
        }
       
        }

        .amountbtn {
            width: fit-content;
            /* top: 10px; */
            /* left: 290px; */
            font-weight: 700;
            background-color: #FCD863;
            border-radius: 20px;
            font-size: 17px;
        }

        @media (max-width: 480px) {
            .amountbtn {
                /* left: 350px; */
            }
            .logo {
                /* top: 10px; */
            }
            button {
                /* top: 22px; */
                /* left: 80px; */
            }
        }

       
        @media (max-width: 475px) {
            button {
                /* top: 20px; */
            }
        }

        @media (max-width: 470px) {
            button {
                /* top: 10px; */
            }
        }

        /* @media (max-width: 470px) {
            button {
                top: 22px;
            }
        } */
        
        @media (max-width: 450px) {
            .amountbtn {
                font-size: 16px;
                /* left: 325px; */
            }
        }

        @media (max-width: 450px) {
            .amountbtn {
                font-size: 16px;
                /* left: 325px; */
            }
        }
    
        @media (max-width: 420px) {
            .amountbtn {
                /* left: 290px; */
                font-size: 17px;
                /* top: 20px; */
            }

            button {
                /* top: 22px; */
                /* left: 80px; */
            }
        }

        

        @media (max-width: 400px) {
            button {
                /* top: 22px; */
                /* left: 80px; */
            }
            .amountbtn {
                /* top: 20px; */
                /* left: 270px; */
                font-size: 17px;
            }
        }

        @media (max-width: 380px) {
            .amountbtn {
                /* left: 250px; */
            }
        }

        @media (max-width: 350px) {
            .amountbtn {
                /* left: 240px; */
            }
        }

        /* Drag Top Bar */

        .side-menu a {
        display: block;
        text-decoration: none;
        color: #fff;
        }

        .icon-tap {
        position: relative;
        }

        .side-menu {
            /* position: fixed; 
            top: 0; 
            left: 0; 
            width: 100%; 
            height: 15%;
            background: #ccc;
            overflow: hidden; 
            transition: top 0.3s ease; 
            z-index: 1000;  */
        }
        /* #container {
  position: relative;
  height: 100vh;
}

#current-page {
  height: 100vh;
  background: #f0f0f0;
} */
    body.hidden-scroll {
            overflow: hidden;
        }
        #side-menu {
            position: relative; /* Use fixed positioning for proper visibility */
            top: -100%; /* Initially hidden off-screen */
            left: 0;
            width: 100%;
            background: #fff;
            z-index: 1000;
            transition: top 0.5s ease-in-out;
        }

        .icon-drag {
          font-size: 45px;
        }

        .container1 {
          width: 100%;
          margin: 10px auto;
        }
        .slider-vertical .slick-prev:before, .slider-vertical .slick-next:before {
          display: none;
        }
        .slider-vertical .slick-prev, .slider-vertical .slick-next {
            width: 0;
            height: 0;
            border-style: solid;
            margin: 10px;
            display: inline-block;
            left: 0;
            right: 0;
            margin: auto;
            z-index: 10;
            cursor: pointer;
        }
        .slider-vertical .slick-prev {
            border-width: 0 14px 14px 14px;
            border-color: #000000 transparent;
            top: -30px;
        }
        .slider-vertical .slick-next {
            border-width: 14px 14px 0px 14px;
            border-color: #000000 transparent;
            bottom: -30px;
            top: auto;
        }	
        .slider-vertical .slick-prev.slick-disabled, .slider-vertical .slick-next.slick-disabled {
          opacity: 0.1;
          cursor: default;
        }
        .slider-vertical div {
          text-align: center;
          font-size: 50px;
          color: #000;
        }

        .slider-vertical .slick-next {
          bottom: -20px;
        }

        .slider-vertical .slick-prev {
          top: -10px;
        }
        

        /* Light box */
        .lightbox {
          display: flex;
          justify-content: center;
          align-items: center;
          position: fixed;
          top: 0;
          left: 0;
          width: 100%;
          height: 100%;
          background: rgba(0, 0, 0, 0.7);
          z-index: 999;
      }

      .image-container {
          width: 600px;
          height: 408px;
          position: relative;
          text-align: center;
          display: flex;
          flex-direction: column;
          justify-content: center;
          align-items: center;
          border-radius: 5px;
      }

      @media (max-width: 580px) {
          .image-container {
          width: 400px;
          height: 280px;
      }
      }
      .img {
          max-width: 100%;
      }

      label {
          padding: 20px;
          font-size: 25px;
          font-weight: 600;
      }

      label:hover {
          background-color: #f1f1f1;
      }

      .custom-radio {
          width: 25px; 
          height: 25px; 
      }

      .text-end {
        text-align: right; 
    }

    .lightbox, .side-menu {
        display: none;
    }

    .mobile-text {
        display: block;
    }

    .disabled {
        pointer-events: none; 
        opacity: 0.7;
    }

    .side-menu.visible {
        top: 0; 
    }

    #side-menu {
        /* display: none; */
    }

    @media (max-width: 480px) {
        #side-menu {
            /* display: block; */
            background-color: #ccc;
        }

        .lightbox {
            display: flex;
        }

        .mobile-text {
            display: none;
        }
    }
    html {
    scroll-behavior: smooth;
}




/* TOP CARD */
.message {
    background-color: #ccc;
color:#FFF;
position: fixed;
top: -250px;
left: 0;
width: 100%;
height: 15%;
padding: 20px;
transition:  top 0.5s ease-in-out, opacity 0.5s ease-in-out;
        transition: top 1s cubic-bezier(0.17, 0.04, 0.03, 0.94);
        overflow: hidden;
        box-sizing: border-box;
        box-shadow: 0px 7px 5px rgba(0, 0, 0, 0.25);
  
}

#toggle {
  position:absolute;
  appearance:none;
  cursor:pointer;
  left:-100%;
  top:-100%;
}

#toggle + label {
  position:absolute;
  cursor:pointer;
  padding:10px;
  background: #26ae90;
width: 100px;
border-radius: 3px;
padding: 8px 10px;
color: #FFF;
line-height:20px;
font-size:12px;
text-align:center;
-webkit-font-smoothing: antialiased;
cursor: pointer;
  margin:20px 50px;
  transition:all 500ms ease;
}
#toggle + label:after {
  content:"Open" 
}

#toggle:checked ~ .message {
  top: 0;
}

#toggle:checked ~ .container {
  margin-top: 140px;
}

#toggle:checked + label {
  background:#dd6149;
}

#toggle:checked + label:after {
  content:"Close";
}

.container.disabled {
    pointer-events: none;
    opacity: 0.7; 
}

.container {
  transition: margin-top 0.5s ease-in-out;
  --bs-gutter-x: 0rem;
}

.btn-dashboard {
    border: 2px solid #FCD863;
    color: #FCD863;
    border-radius: 10px;
}

.btn-dashboard:hover {
    border: 2px solid #0B132B;
    color: #0B132B;  
}

.btn-dashboard i {
    width: 30px;
    height: 30px;
    font-size: 30px;
}

.btn-dashboard-layour {
    text-align: right;
    overflow: hidden !important;
}


/* Explore Button */
/* Basic Styles */

@media (max-width: 480px) {
    .col-md-6 {
        width: 50%;
    }
}

    </style>   

</head>
<body class="hidden-scroll">

    <h1 class="mobile-text text-center">Change to Mobile VIew</h1>
     <!-- Lightbox -->
    <div id="lightbox" class="lightbox" style="display: none;">
        <div class="image-container">
            <div class="card" style="padding: 20px; height: fit-content; width: 100%;">
                <div class="row d-flex align-items-center">
                    <div class="col-md-11 col-11"></div>
                    <div class="col-md-1 col-1 text-end justify-content-end">
                        <a class="btn btn-default text-end" id="closeLightbox" style="right: 10%; color: #000; text-decoration: none;"><i class="fa fa-x" style="font-weight: 900;"></i></a>
                    </div>
                </div>
                <label for="c1">Category 1&nbsp;&nbsp;<span><input type="radio" name="category" id="c1" class="custom-radio" aria-selected="true" checked></span></label>
                <label for="c2">Category 2&nbsp;&nbsp;<span><input type="radio" name="category" id="c2" class="custom-radio"></span></label>
                <label for="c3">Category 3&nbsp;&nbsp;<span><input type="radio" name="category" id="c3" class="custom-radio"></span></label>
                <label for="c4">Category 4&nbsp;&nbsp;<span><input type="radio" name="category" id="c4" class="custom-radio"></span></label>
                <label for="c5">Category 5&nbsp;&nbsp;<span><input type="radio" name="category" id="c5" class="custom-radio"></span></label>
            </div>
        </div>
    </div>

        <input type="checkbox" name="toggle" id="toggle" style="display: none;"/>
        <label for="toggle" style="display: none;"></label>
    <!-- <div id='root'> -->
        <div id="container" class="container">
            <div class="page-head" id="page-head">
                <div class="row">
                    <div class="col-md-6">
                        <div class="logo">hapi <span class="taplogo">tap</span></div>
                    </div>
                    <div class="col-md-6 text-end">
                    <button  class="btn btn-default amountbtn" style=""><i class="fa fa-calculator"></i>  ₹ 1000</button>
                    </div>
                </div>
            </div>
            <!-- <button id="tapLogoButton${index}" class="" style="opacity: 1; transform: translateX(0px); transition: transform 0.3s ease-in;"></button> -->
            <div class="row content">
                <!-- 1st Card ======================== TEA-->
                <div class="col-6">
                    <div class="card">
                        <div class="card-content text-center">
                            <div class="row">
                                <div class="col-6 text-start">
                                    <p class="num-anim">+1</p>
                                </div>
                                <div class="col-6 text-end">
                                    <p class="increase-num">0</p>
                                </div>
                            </div>
                            <img src="assests/images/tea.png" alt="">
                        </div>
                        <div class="card-title text-center card-title-tea">
                            <p>Tea</p>
                        </div>
                    </div>
                </div>
                <!-- 2nd Card ======================= COFFEE-->
                <div class="col-6">
                    <div class="card">
                        <div class="card-content text-center">
                            <div class="row">
                                <div class="col-6 text-start">
                                    <p class="num-anim">+1</p>
                                </div>
                                <div class="col-6 text-end">
                                    <p class="increase-num">0</p>
                                </div>
                            </div>
                            <img src="assests/images/tea.png" alt="">
                        </div>
                        <div class="card-title text-center card-title-coffee">
                            <p>Coffee</p>
                        </div>
                    </div>
                </div>
                <!-- 3rd Card ========================= PAV -->
                <div class="col-6">
                    <div class="card">
                        <div class="card-content text-center">
                            <div class="row">
                                <div class="col-6 text-start">
                                    <p class="num-anim">+1</p>
                                </div>
                                <div class="col-6 text-end">
                                    <p class="increase-num">0</p>
                                </div>
                            </div>
                            <img src="assests/images/tea.png" alt="">
                        </div>
                        <div class="card-title text-center card-title-pav">
                            <p>Pav</p>
                        </div>
                    </div>
                </div>

                <!-- 4th Card ============================= VADA -->
                <div class="col-6">
                    <div class="card">
                        <div class="card-content text-center">
                            <div class="row">
                                <div class="col-6 text-start">
                                    <p class="num-anim">+1</p>
                                </div>
                                <div class="col-6 text-end">
                                    <p class="increase-num">0</p>
                                </div>
                            </div>
                            <img src="assests/images/tea.png" alt="">
                        </div>
                        <div class="card-title text-center card-title-vada">
                            <p>Vada</p>
                        </div>
                    </div>
                </div>
                <!-- 5th Card ================================ CHOCOLATE -->
                <div class="col-6">
                    <div class="card">
                        <div class="card-content text-center">
                            <div class="row">
                                <div class="col-6 text-start">
                                    <p class="num-anim">+1</p>
                                </div>
                                <div class="col-6 text-end">
                                    <p class="increase-num">0</p>
                                </div>
                            </div>
                            <img src="assests/images/tea.png" alt="">
                        </div>
                        <div class="card-title text-center card-title-choco">
                            <p>Chocolate</p>
                        </div>
                    </div>
                </div>
                <!-- 6th Card ================================== SODA -->
                <div class="col-6">
                    <div class="card">
                        <div class="card-content text-center">
                            <div class="row">
                                <div class="col-6 text-start">
                                    <p class="num-anim">+1</p>
                                </div>
                                <div class="col-6 text-end">
                                    <p class="increase-num">0</p>
                                </div>
                            </div>
                            <img src="assests/images/tea.png" alt="">
                        </div>
                        <div class="card-title text-center card-title-soda">
                            <p>Soda</p>
                        </div>
                    </div>
                </div>
                <!-- 7th Card ================================== BREEZER -->
                <div class="col-6">
                    <div class="card">
                        <div class="card-content text-center">
                            <div class="row">
                                <div class="col-6 text-start">
                                    <p class="num-anim">+1</p>
                                </div>
                                <div class="col-6 text-end">
                                    <p class="increase-num">0</p>
                                </div>
                            </div>
                            <img src="assests/images/tea.png" alt="">
                        </div>
                        <div class="card-title text-center card-title-breezer">
                            <p>Breezer</p>
                        </div>
                    </div>
                </div>
                <!-- 8th Card ================================== COKE -->
                <div class="col-6">
                    <div class="card">
                        <div class="card-content text-center">
                            <div class="row">
                                <div class="col-6 text-start">
                                    <p class="num-anim">+1</p>
                                </div>
                                <div class="col-6 text-end">
                                    <p class="increase-num">0</p>
                                </div>
                            </div>
                            <img src="assests/images/tea.png" alt="">
                        </div>
                        <div class="card-title text-center card-title-coke">
                            <p>Coke</p>
                        </div>
                    </div>
                </div>

                <div class="col-6">
                    <div class="card">
                        <div class="card-content text-center">
                            <div class="row">
                                <div class="col-6 text-start">
                                    <p class="num-anim">+1</p>
                                </div>
                                <div class="col-6 text-end">
                                    <p class="increase-num">0</p>
                                </div>
                            </div>
                            <img src="assests/images/tea.png" alt="">
                        </div>
                        <div class="card-title text-center card-title-coke">
                            <p>Coke</p>
                        </div>
                    </div>
                </div><div class="col-6">
                    <div class="card">
                        <div class="card-content text-center">
                            <div class="row">
                                <div class="col-6 text-start">
                                    <p class="num-anim">+1</p>
                                </div>
                                <div class="col-6 text-end">
                                    <p class="increase-num">0</p>
                                </div>
                            </div>
                            <img src="assests/images/tea.png" alt="">
                        </div>
                        <div class="card-title text-center card-title-coke">
                            <p>Coke</p>
                        </div>
                    </div>
                </div>
                <div class="col-6">
                    <div class="card">
                        <div class="card-content text-center">
                            <div class="row">
                                <div class="col-6 text-start">
                                    <p class="num-anim">+1</p>
                                </div>
                                <div class="col-6 text-end">
                                    <p class="increase-num">0</p>
                                </div>
                            </div>
                            <img src="assests/images/tea.png" alt="">
                        </div>
                        <div class="card-title text-center card-title-coke">
                            <p>Coke</p>
                        </div>
                    </div>
                </div>



<?php

$productquery= "SELECT * FROM product WHERE delete_status=0 AND mode=1";
$productqueryexe = mysqli_query($connection, $productquery);

if (mysqli_num_rows($productqueryexe) > 0) {
    while ($product = mysqli_fetch_array($productqueryexe)) {
        // Product details from the database
        $productid = $product['id'];
        $productName = $product['productname'];
        $productPrice = $product['price'];
        $productWeight = $product['munit'];
        $productAvailability = $product['qty'];
        $seotitle = $product['seotitle'];
        $seodescription = $product['seodescription'];
        $productOldPrice = $product['purchaseprice'];
        $productimage = $product['productimage'];


?>
                <div class="col-6">
                    <div class="card"  data-productid="<?php echo $productid; ?>" data-productname="<?php echo $productName; ?>" data-amount="<?php echo $productPrice; ?>">
                        <div class="card-content text-center">
                            <div class="row">
                                <div class="col-6 text-start">
                                    <p class="num-anim">+1</p>
                                </div>
                                <div class="col-6 text-end">
                                    <p class="increase-num">0</p>
                                </div>
                            </div><p style="display:none;"><?php echo $productid?></p>
                            <img src="<?php echo $productimage ;?>" alt="<?php echo $seotitle;?>" title="<?php echo $seodescription;?>">
                        </div>
                        <div class="card-title text-center card-title-coke">
                            <p><?php echo $productName; ?></p>
                            <p style="display:none;"> <?php echo $productPrice;?></p>
                        </div>
                    </div>
                </div>

        
                <?php
    }
} else {
    echo "<p>No products available.</p>";
}
?>

                <!-- <div class="col-12 btn-dashboard-layour">
                    <input type="range" value="0" class="pullee" />
                </div> -->
                <div class="slider-container">
                    <input type="range" value="0" class="styled-slider pullee" min="0" max="150" />
                    <div class="slider-track-content">
                        <span class="slider-text">Dashboard</span>
                    </div>
                </div>
                
                
                
            </div>
        </div>
    <!-- </div> -->
      <!-- Menu Drag -->
    <div class="message" id="">
        <div class="row" style="padding: 20px;">
            <div class="col-md-3 col-3 text-left">
                <img src="assests/images/undo.png" alt="" style="width: 80px; margin-left: -20px;">
            </div>
            <div class="col-md-6 col-6">
                <div class="container1">
                    <div class="slider-vertical">
                        <div><h3>Morning</h3></div>
                        <div><h3>Afternoon</h3></div>
                        <div><h3>Evening</h3></div>
                        <div><h3>Night</h3></div>
                    </div>  
                </div>
            </div>
             <div class="col-md-3 col-3 text-end">
                <img src="assests/images/shield.png" alt="" style="width: 80px;">
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
   
       


<!-- Card number count -->
<script>
$(document).ready(function() {
    const cards = $('.card');

    cards.each(function() {
        $(this).data('count', 0);  // Initialize the tap count

        $(this).on('click', function() {
            // Get and increment the tap count
            let count = $(this).data('count') + 1;
            $(this).data('count', count);

            // Update `numAnim` to show cumulative `+count` and animate it
            const numAnim = $(this).find('.num-anim');
            numAnim.text(`+${count}`).css('display', 'block').removeClass('animate');
            void numAnim.get(0).offsetWidth;  // Trigger reflow to restart animation
            numAnim.addClass('animate');

            // Update `increaseNum` to reflect the stable cumulative count
            const increaseNum = $(this).find('.increase-num');
            increaseNum.text(count);

            // Send AJAX request with updated count
            sendTapData($(this).data('productid'), $(this).data('productname'), $(this).data('amount'), count);

            // Hide `numAnim` after a delay, without resetting the cumulative `count`
            if ($(this).data('resetTimeout')) {
                clearTimeout($(this).data('resetTimeout'));
            }
            $(this).data('resetTimeout', setTimeout(() => {
                numAnim.css('display', 'none');  // Hide the animated display only
            }, 500));
        });
    });

    function sendTapData(productId, productName, amount, taps) {
        $.ajax({
            url: 'recordTap.php',  // Your PHP backend script
            type: 'POST',
            data: {
                productid: productId,
                productname: productName,
                amount: amount,
                taps: taps
            },
            success: function(response) {
                console.log(response);  // Debugging response
            },
            error: function() {
                alert("Error sending tap data.");
            }
        });
    }
});
</script>





<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.1.0/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-mousewheel/3.1.12/jquery.mousewheel.js"></script>
<script src="https://kenwheeler.github.io/slick/slick/slick.js"></script>


<!-- Vertical Carousel -->
<script>
  var slickCarousel = $('.slider-vertical');
  slickCarousel.slick({
      dots: true,
      infinite: false,
      speed: 300,
      slidesToShow: 1,
      slidesToScroll: 1,
      vertical: true,
      verticalSwiping: true,
      dots: false,
      centerPadding: '50px',
      arrows: true,
      prevArrow: '<button type="button" data-role="none" class="slick-prev" aria-label="Previous" tabindex="0" role="button"><i class="fa fa-angle-up"></i></button>',
      nextArrow: '<button type="button" data-role="none" class="slick-next" aria-label="Next" tabindex="0" role="button"><i class="fa fa-angle-down"></i></button>',
      responsive: [{
              breakpoint: 1024,
              settings: {
                  slidesToShow: 1,
                  slidesToScroll: 1,
                  infinite: true,
              }
          }, {
              breakpoint: 639,
              settings: {
                  slidesToShow: 1,
                  slidesToScroll: 1,
            vertical: false,
            verticalSwiping: false,
              }
          }
      ]
  });

  slickCarousel.mousewheel(function(e) {
  e.preventDefault();
      if (e.deltaY < 0) {
          $(this).slick('slickNext'); 
      }
      else {
          $(this).slick('slickPrev');
      }
  });
</script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/2.1.3/jquery.min.js"></script>


<!-- Drag up and down rly drag and tap -->
 <script>
document.addEventListener('DOMContentLoaded', function () {
    const toggle = document.getElementById('toggle');
    const container = document.querySelector('.container');
    const message = document.querySelector('.message');
    const lightbox = document.getElementById('lightbox');
    let startY = 0;
    let isDragging = false;

    function handleTouchStart(e) {
        startY = e.touches[0].clientY;
        isDragging = true;
    }

    function handleTouchMove(e) {
        if (!isDragging) return;

        const currentY = e.touches[0].clientY;
        const distance = currentY - startY;

        
        if (distance > 0 && distance >= 400) {
            toggle.checked = true;
            container.classList.add('disabled'); 
            message.classList.add('show');
            message.classList.remove('hide');
            isDragging = false;  
        }

        if (distance < 0 && Math.abs(distance) >= 100) {
            message.classList.add('hide'); 
            message.classList.remove('show'); 
            setTimeout(() => {
                toggle.checked = false;
                container.classList.remove('disabled'); 
            }, 500); 
            isDragging = false;  
        }
    }

    function handleClickOutsideMessage(e) {
        if (!message.contains(e.target) && !container.contains(e.target) && !lightbox.contains(e.target)) {
            message.classList.add('hide');
            message.classList.remove('show');
            container.classList.remove('disabled');
            toggle.checked = false;
        }
    }

    container.addEventListener('touchstart', handleTouchStart);
    container.addEventListener('touchmove', handleTouchMove);
    message.addEventListener('touchstart', handleTouchStart);
    message.addEventListener('touchmove', handleTouchMove);

    document.addEventListener('click', handleClickOutsideMessage);

    container.addEventListener('touchend', function () {
        isDragging = false;
    });
    message.addEventListener('touchend', function () {
        isDragging = false;
    });

    document.querySelectorAll('.slider-vertical > div').forEach(function(item) {
        item.addEventListener('click', function() {
            lightbox.style.display = 'flex';
        });
    });

    document.getElementById('closeLightbox').addEventListener('click', function() {
        lightbox.style.display = 'none';
    });

    lightbox.addEventListener('click', function(e) {
        if (e.target === this) {
            this.style.display = 'none';
        }
    });
});

 </script>


<script>
var inputRange = document.querySelector('.pullee');
var maxValue = inputRange.max;
var sliderText = document.querySelector('.slider-text');

// Function to update the arrow on the slider thumb
function updateArrow() {
    var currValue = +inputRange.value;

    if (currValue === 0) {
        inputRange.style.setProperty('background-image', 'url(data:image/svg+xml,%3Csvg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="black" class="bi bi-arrow-right" viewBox="0 0 16 16"%3E%3Cpath fill-rule="evenodd" d="M1 8a.5.5 0 0 1 .5-.5H12.293l-3.147-3.146a.5.5 0 1 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 1 1-.708-.708L12.293 8.5H1.5A.5.5 0 0 1 1 8z"/%3E%3C/svg%3E');
    } else if (currValue >= maxValue) {
        inputRange.style.setProperty('background-image', 'url(data:image/svg+xml,%3Csvg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="black" class="bi bi-arrow-left" viewBox="0 0 16 16"%3E%3Cpath fill-rule="evenodd" d="M15 8a.5.5 0 0 1-.5.5H3.707l3.147 3.146a.5.5 0 0 1-.708.708l-4-4a.5.5 0 0 1 0-.708l4-4a.5.5 0 1 1 .708.708L3.707 7.5H14.5A.5.5 0 0 1 15 8z"/%3E%3C/svg%3E');
    } else {
        inputRange.style.setProperty('background-image', 'none');
    }
}

// Function to update the slider text position along the track
function updateSliderText() {
    var currValue = +inputRange.value;
    var percentage = (currValue / maxValue) * 100;
    sliderText.style.left = `calc(${percentage}% - 50px)`; // Adjust `-50px` to center the text
}

// Add event listener for input change
inputRange.addEventListener('input', function () {
    updateArrow();
    updateSliderText();

    var currValue = +this.value;
    if (currValue >= maxValue) {
        successHandler();
    }
});

// Function to handle the success (i.e., when the slider is at the max value)
function successHandler() {
    sessionStorage.setItem('sliderAtMax', 'true');

    setTimeout(function() {
        window.location.href = "dashboard.php"; // Redirect to dashboard page
    }, 500);
}

// On page load, check if the slider reached the max and reset it to the left
window.addEventListener('load', function() {
    if (sessionStorage.getItem('sliderAtMax') === 'true') {
        // Reset the slider to 0 (left) when coming back from dashboard
        setTimeout(function() {
            inputRange.value = 0; // Reset slider to the left position
            updateArrow(); // Update arrow position
            updateSliderText(); // Update text position
            sessionStorage.removeItem('sliderAtMax'); // Clean up session storage
        }, 10);
    }
});
</script>

</body>
</html>
